/* eslint-disable max-len */
define([
    'underscore',
    'backbone',
    'modules/appointments/appointments-module',
    'App',
    'User',
    'modules/community-care-request/view/community-care-view',
    'modules/new-appointment-wizard/wizard-step-model',
    'text!modules/community-care-request/new-appointment-request-question/notification-selection/community-care-notification-settings-layout.html',
    'modules/community-care-request/new-appointment-request-question/notification-selection/request-details/request-details-phone-contact-section-view',
    'modules/new-appointment-request/views/common/email/section-view',
    'modules/loading-spinner/loading-spinner',
    'modules/notification-preferences/notification-preferences-module',
    'models/resources-collection',
    'modules/appointments/messages/request-message-view',
    'models/request-model',
    'modules/new-appointment-request/views/requests/message/section-view',
    'modules/page/core/behaviors/focus-cc-on-header-behavior',
],
function (
    _,
    Backbone,
    module,
    app,
    User,
    CommunityCareView,
    WizardStepModel,
    template,
    PhoneContactSectionView,
    EmailPreferencesSectionView,
    loadingSpinner,
    notificationPreferencesModule,
    Resources,
    MessageView,
    RequestModel,
    NewMessageSectionView,
    Focus
) {
    'use strict';
    // TODO make a Wizard Page Layout View that this can extend to make some methods such as declaimFDNS   trols, disableContinue, enableContinue, showPrevious DRY
    return CommunityCareView.extend({
        template: _.template(template),
        regions: {
            communityCareSettings: '.community-care-settings',
            newMessageRegion: '.request-details-new-message-section',
            emailPreferencesRegion: '.email-preferences-section',
        },
        events: _.extend({}, CommunityCareView.prototype.events, {
            'submit #new-appointment-request-form': 'preventDefault',
            'click #submit-btn': 'saveSettings',
            'change #emailAddress': 'handleModelChange',
        }),
        modelEvents: {
            'change:bestTimeToCall': 'handleModelChange',
            'change:phoneNumber': 'handleModelChange',
            'change:emailAddress': 'handleModelChange',
        },
        initialize: function (options) {
            if (_.isUndefined(options)) {
                this.model = new WizardStepModel.Model();
            } else {
                this.model = options.model;
                this.validator = options.validator;
                this.isValid = options.isValid;
                $.when(notificationPreferencesModule.notificationPreferences._isReady).then(function () {
                    // store data in clone of notification preferences until successful save
                    this.emailPreferencesModel = notificationPreferencesModule.notificationPreferences.clone();
                }.bind(this));
            }
        },
        onRender: function () {
            this.disableContinueButton();

            this.showChildView('communityCareSettings', new PhoneContactSectionView({
                model: this.model,
                validator: this.validator,
            }));
            this.showChildView('newMessageRegion', new NewMessageSectionView({
                model: this.model,
            }));
            this.showChildView('emailPreferencesRegion', new EmailPreferencesSectionView({
                model: this.emailPreferencesModel,
                validator: this.validator,
                isForCommunityCare: true,
            }));
        },
        // overrides the community-care-view disableContinueButton function
        disableContinueButton: function() {
            this.ui.submit.prop('disabled', true);
        },
        // overrides the community-care-view enableContinueButton function
        enableContinueButton: function() {
            this.ui.submit.prop('disabled', false);
        },
        saveSettings: function () {
            this.saveCommunityCareRequests(this.model);
            this.saveEmailPreferences();
        },
        saveCommunityCareRequests: function (model) {
            var messageView;
            var submitModel;
            this.clearOutInvalidProviders();
            this.unsetDateTimeForPCP();

            submitModel = this.formatCommunityCareRequests();
            this.unsetHiddenAttributes('travelBurden', submitModel);
            this.unsetHiddenAttributes('unusualTravelBurden', submitModel);
            submitModel.save({}, {
                url: app.resources.get('community-care-requests').formatHref({
                    'assigning-authority': User.get('idType'),
                    'patient-id': User.get('id'),
                }),
            }).done(function (response, success, jqxhr) {
                var appointmentRequestResponse = new RequestModel(response, { parse: true });
                appointmentRequestResponse.set('ccAppointmentRequest', new Backbone.Model({
                    preferredCity: appointmentRequestResponse.get('preferredCity'),
                    preferredLanguage: appointmentRequestResponse.get('preferredLanguage'),
                    preferredProviders: appointmentRequestResponse.get('preferredProviders'),
                    preferredState: appointmentRequestResponse.get('preferredState'),
                    travelBurden: appointmentRequestResponse.get('travelBurden'),
                    unusualTravelBurden: appointmentRequestResponse.get('unusualTravelBurden'),
                    preferredZipCode: appointmentRequestResponse.get('preferredZipCode'),
                }).toJSON());
                module.requests.add(appointmentRequestResponse);
                messageView = new MessageView(appointmentRequestResponse);
                messageView.checkForMessage(submitModel);
            });
        },

        // eslint-disable-next-line complexity
        formatCommunityCareRequests: function () {
            var DISTANCE_TO_TRAVEL_CASE_100 = 100;
            var distanceEligible = this.model.has('distanceEligible') ? this.model.get('distanceEligible') === 'yes' : true;
            var ccRequestModel = new Backbone.Model({
                additionalInformation: this.model.get('additionalPreferences'),
                address: this.model.get('address') ? this.model.get('address') : '',
                appointmentType: this.model.get('careTypeName'),
                bestTimetoCall: this.model.get('bestTimeToCall'),
                ccAppointmentRequest: {preferredZipCode: this.model.get('preferredZipcode')},
                city: this.model.get('city') ? this.model.get('city') : '',
                distanceEligible: distanceEligible,
                distanceWillingToTravel: this.model.get('primaryPreferredMiles') === '100 or more' ? DISTANCE_TO_TRAVEL_CASE_100 : this.model.get('primaryPreferredMiles'),
                email: this.emailPreferencesModel.get('emailAddress'),
                facility: this.model.get('facility'),
                newMessage: this.model.get('newMessage'),
                officeHours: this.model.get('officeHours'),
                optionDate1: this.model.get('optionDate1') ? this.model.get('optionDate1') : 'No Date Selected',
                optionDate2: this.model.get('optionDate2') ? this.model.get('optionDate2') : 'No Date Selected',
                optionDate3: this.model.get('optionDate3') ? this.model.get('optionDate3') : 'No Date Selected',
                optionTime1: this.model.get('optionTime1') ? this.model.get('optionTime1') : 'No Time Selected',
                optionTime2: this.model.get('optionTime2') ? this.model.get('optionTime2') : 'No Time Selected',
                optionTime3: this.model.get('optionTime3') ? this.model.get('optionTime3') : 'No Time Selected',
                patientIdentifier: {
                    assigningAuthority: User.get('idType'),
                    uniqueId: User.get('id'),
                },
                phoneNumber: this.model.get('phoneNumber'),
                preferredCity: this.model.get('primaryCity'),
                preferredLanguage: this.model.get('preferredLanguageSpoken'),
                preferredProviders: this.model.get('preferredProviders'),
                preferredState: this.model.get('primaryState'),
                preferredZipCode: this.model.get('primaryZipCode'),
                providerId: '0',
                providerOption: this.model.get('requestedPhoneCall') ? 'Call before booking appointment' : '',
                purposeOfVisit: 'routine-follow-up',
                reasonForVisit: this.model.get('careType') === 'CCPCPRVDR' ? 'Find a Primary Care Provider' : '',
                requestedPhoneCall: this.model.get('requestedPhoneCall') === 'yes',
                service: this.model.get('service'),
                state: this.model.get('state') ? this.model.get('state') : '',
                travelBurden: this.model.get('travelBurden') === 'yes',
                typeOfCareId: this.model.get('careType'),
                unusualTravelBurden: this.model.get('unusualTravelBurden') === 'yes',
                visitType: 'Office Visit',
                zipCode: this.model.get('zipCode') ? this.model.get('zipCode') : '',
            });
            return ccRequestModel;
        },

        unsetHiddenAttributes: function(attributeName, submitModel) {
            if (!this.model.has(attributeName)) {
                submitModel.unset(attributeName);
                this.model.unset(attributeName);
            }
        },
        saveEmailPreferences: function () {
            notificationPreferencesModule.notificationPreferences.save(
                this.emailPreferencesModel.attributes,
                {
                    url: app.resources.get('notification-preference').formatHref({
                        'assigning-authority': User.get('idType'),
                        'patient-id': User.get('id'),
                    }),
                    type: 'PUT',
                }
            );
        },
        clearOutInvalidProviders: function() {
            _.each(this.model.get('preferredProviders').models, function(provider) {
                _.each(provider.keys(), function(attribute) {
                    if (provider.get(attribute) === '') {
                        provider.unset(attribute);
                    } else if (attribute === 'address') {
                        this.removeEmptyAddress(provider);
                    }
                }.bind(this));
            }.bind(this));
        },

        removeEmptyAddress: function(provider) {
            var isEmpty = true;
            var key;
            for (key in provider.get('address')) {
                if (provider.get('address')[key] !== '') {
                    isEmpty = false;
                }
            }

            if (isEmpty) {
                provider.unset('address');
            }
        },
        unsetDateTimeForPCP: function() {
            if (this.model.get('careType') === 'CCPCPRVDR') {
                this.model.unset('optionDate1');
                this.model.unset('optionDate2');
                this.model.unset('optionDate3');
                this.model.unset('optionTime1');
                this.model.unset('optionTime2');
                this.model.unset('optionTime3');
            }
        },

    });
});
